/**
 * This is a lamda call script.
 * it is injected into the body tag after site is completely loaded
 * It requires the object UPTAIN_DATA which must be in place.
 * The UPTAIN_DATA object is created by upta_snippet.tpl
 */
(function () {
    function ready(callback) {
        // in case the document is already rendered
        if (document.readyState != 'loading') callback();
        // modern browsers
        else if (document.addEventListener) document.addEventListener('DOMContentLoaded', callback);
        // IE <= 8
        else document.attachEvent('onreadystatechange', function () {
                if (document.readyState == 'complete') callback();
            });
    }

    ready(function () {
        if (undefined === UPTAIN_DATA) {
            console.error("UPTAIN_DATA object not present. UPTAIN_DATA object must be in place.");
        } else {
            let s = document.createElement('script');
            s.type = 'text/javascript';
            for (const [key, value] of Object.entries(UPTAIN_DATA)) {
                s.dataset[key] = value;
            }
            s.src = "https://app.uptain.de/js/uptain.js?x=" + UPTAIN_DATA.token;
            s.id = "__up_data_qp";
            document.body.appendChild(s);
        }
    });
})();
